package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.DailyTravelOrderStatistics;
import com.xxfc.platform.order.mapper.DailyTravelOrderStatisticsMapper;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 每日旅游订单统计
 * @author Administrator
 */
@Service
public class DailyTravelOrderStatisticsBiz extends BaseBiz<DailyTravelOrderStatisticsMapper, DailyTravelOrderStatistics> {


    public boolean StatisticsOfTravelOrders()  {
        try {
            HashMap<String, Object> resultMap = new HashMap<>();
            Map<String,Object> travelGmv = mapper.getTravelGmv();
            BigDecimal travelPenalSum = mapper.getTravelPenalSum();
            resultMap.putAll(travelGmv);
            resultMap.put("penalSum",travelPenalSum);
            DailyTravelOrderStatistics TravelStatistics = new DailyTravelOrderStatistics();
            BeanUtils.copyProperties(TravelStatistics,resultMap);
            insertSelective(TravelStatistics);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
