package com.xxfc.platform.order.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;
import tk.mybatis.mapper.annotation.KeySql;
import tk.mybatis.mapper.code.IdentityDialect;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

/**
 * 每日租车订单统计
 * @author Administrator
 */
@Data
@Table(name = "daily_vehicle_order_statistics")
public class DailyVehicleOrderStatistics extends DailyOrderStatistics{

    /**
     * 成交总金额
     */
    @Column(name = "gmv")
    private BigDecimal gmv;

    /**
     * 预交押金总额
     */
    @Column(name = "security_deposit")
    private BigDecimal  securityDeposit;

    /**
     * 退还押金总额
     */
    @Column(name = "refund_security_deposit")
    private BigDecimal  refundSecurityDeposit;

    /**
     * 赔偿总额
     */
    @Column(name = "compensation")
    private BigDecimal compensation;

    /**
     * 违章总额
     */
    @Column(name = "forfeit")
    private  BigDecimal violationMoney;


    /**
     * 延期总额
     */
    @Column(name = "postpone")
    private  BigDecimal postpone;


}
