package com.xxfc.platform.order.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.order.biz.OrderMemberDetailBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderMemberDetail;
import com.xxfc.platform.order.pojo.order.add.AddMemberDTO;
import com.xxfc.platform.order.pojo.order.MemberBO;
import com.xxfc.platform.order.service.OrderMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("orderMember")
@Api(value="会员订单",tags={"会员订单"})
@IgnoreClientToken
public class OrderMemberController extends BaseController<OrderMemberDetailBiz,OrderMemberDetail> {

    @Autowired
    OrderMemberService orderMemberService;

    @Autowired
    UserFeign userFeign;

    @RequestMapping(value = "add",method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "确认会员订单")
    public ObjectRestResponse<BaseOrder> add(@RequestBody AddMemberDTO dto){
        MemberBO bo = BeanUtil.toBean(dto, MemberBO.class);

        //查询会员等级实体
//        bo.setBaseUserMemberLevel(userFeign.memberEntityList(BeanUtil.beanToMap(new BaseUserMemberLevel(){{
//            setId(dto.getMemberLevelId());
//        }})).getData().get(0));

//        bo.setMemberLevelId(bo.getBaseUserMemberLevel().getId());

        //查询优惠券
        orderMemberService.createOrder(bo);
        return ObjectRestResponse.succ(bo.getOrder());
    }

}