package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.xxfc.platform.vehicle.biz.BranchCompanyBiz;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.feign.UserFeign;
import com.xxfc.platform.vehicle.feign.dto.UserDTO;
import com.xxfc.platform.vehicle.vo.BranchCompanyVo;
import com.xxfc.platform.vehicle.vo.CompanySearchDTO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/branchCompany")
@Slf4j
@IgnoreClientToken
@IgnoreUserToken
public class BranchCompanyController extends BaseController<BranchCompanyBiz> {

    private static Integer MAX_DRIVING_LICENSE_SIZE  = 10*1024*1024;//10M

    @Autowired
    UserFeign userFeign;

    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @RequestMapping(value ="/page",method = RequestMethod.GET)
    public RestResponse<PageDataVO<BranchCompany>> page(@RequestParam Integer page, @RequestParam Integer limit,
                                                        @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                        @RequestParam(required = false) Integer addrTown, @RequestParam(required = false) String location) {
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, userDTO));
    }

    @IgnoreUserToken
    @RequestMapping(value = "/allPage", method = RequestMethod.GET)
    public RestResponse<PageDataVO<BranchCompany>> allPage(@RequestParam Integer page, @RequestParam Integer limit,
                                                           @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                           @RequestParam(required = false) Integer addrTown) {
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, null));
    }

    @RequestMapping(value ="/search",method = RequestMethod.GET)
    @IgnoreUserToken
    @IgnoreClientToken
    public RestResponse<PageDataVO<BranchCompany>> search(@Validated CompanySearchDTO vo) {
        return RestResponse.data(baseBiz.search(vo));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<BranchCompany>> getAll() {
        return RestResponse.data(baseBiz.getAll());
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.GET)
    public RestResponse<BranchCompany> get(@PathVariable Integer id) {
        return RestResponse.data(baseBiz.getById(id));
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    public RestResponse<Integer> add(@RequestBody BranchCompanyVo branchCompanyVo) {
        return RestResponse.data(baseBiz.add(branchCompanyVo));
    }

    @RequestMapping(value ="/upload/companyPic",method = RequestMethod.POST)
    public RestResponse uploadCompanyPic(@RequestParam("file") MultipartFile file)
            throws Exception{
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
        if(!contentType.equals("image/jpeg") && !contentType.equals("image/gif")){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if(file.getSize() > MAX_DRIVING_LICENSE_SIZE){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.uploadCompanyPic(file);
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    public RestResponse update(@RequestBody BranchCompany branchCompany) {
        baseBiz.update(branchCompany);
        return RestResponse.sucResponse();
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    public RestResponse del(@PathVariable Integer id) {
        baseBiz.del(id);
        return RestResponse.sucResponse();
    }

    /**
     * 导入
     * @param multipartfile
     * @param request
     * @return
     */
    @PostMapping("importExcel")
    public RestResponse importExcel(@RequestParam(value = "file") MultipartFile multipartfile,
                                    HttpServletRequest request) {
        return baseBiz.importExcel(multipartfile,request);
    }

}
