package com.xxfc.platform.vehicle.vo;

import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;

import static java.time.LocalDateTime.ofEpochSecond;

@Data
public class UsableVeicleDTO {
        public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        Integer page;
        Integer limit;
        Integer addrCity;
        String lon;
        String lat;
        String startDate;
        String endDate;
        Long startDateTamp;
        Long endDateTamp;
        String priceStart;
        String priceEnd;
        String catasStr;
        List<Integer> catas;

        public void setStartDateTamp(Long startDateTamp) {
                this.startDateTamp = startDateTamp;
                this.startDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofEpochSecond(startDateTamp, 0, ZoneOffset.ofHours(8)));
        }

        public void setEndDateTamp(Long endDateTamp) {
                this.endDateTamp = endDateTamp;
                this.endDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofEpochSecond(endDateTamp, 0, ZoneOffset.ofHours(8)));
        }
}