package com.xxfc.platform.universal.biz;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.controller.OrderRefundController;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import com.xxfc.platform.universal.weixin.api.WxPayRefundUtils;
import com.xxfc.platform.universal.weixin.util.OrderUtil;
import com.xxfc.platform.universal.weixin.util.Snowflake;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.universal.entity.OrderRefund;
import com.xxfc.platform.universal.mapper.OrderRefundMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

/**
 * 订单支付退款表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Service
@Slf4j
public class OrderRefundBiz extends BaseBiz<OrderRefundMapper,OrderRefund> {


    //申请退款
    public JSONObject refund(OrderRefundVo orderRefundVo)throws Exception{
        if(orderRefundVo==null){
            log.error("-----参数为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        String out_trade_no=orderRefundVo.getOrderNo();
        String appid= SystemConfig.APP_ID;
        String mchId=SystemConfig.APP_PARTNER;
        String partnerKey=SystemConfig.APP_PARTNER_KEY;
        Integer payAmount=orderRefundVo.getAmount();
        Integer refundAmount=orderRefundVo.getRefundAmount();
        String refundDesc =StringUtils.isNotBlank(orderRefundVo.getRefundDesc())?orderRefundVo.getRefundDesc(): "审核通过，退款";
        String out_refund_no = Snowflake.build() + "";
        if(StringUtils.isBlank(out_trade_no)||StringUtils.isBlank(appid)||StringUtils.isBlank(mchId)||StringUtils.isBlank(partnerKey)
        ||payAmount==null||payAmount==0||refundAmount==null||refundAmount==0){
            log.error("-----参数为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        boolean flag=WxPayRefundUtils.refund(appid,mchId,partnerKey,out_trade_no,out_refund_no,payAmount+"",
                refundAmount+"",refundDesc);
        if(flag){
            OrderRefund orderRefund= new OrderRefund();
            BeanUtils.copyProperties(orderRefund,orderRefundVo);
            if(StringUtils.isNotBlank(orderRefund.getRefundDesc())){
                orderRefund.setRefundDesc(refundDesc);
            }
            orderRefund.setStatus(2);
            orderRefund.setFinishTime(System.currentTimeMillis());
            String trade_no =  OrderUtil.GetOrderNumber("");
            orderRefund.setRefundTradeNo(trade_no);
            orderRefund.setOutRefundNo(out_refund_no);
            insertSelective(orderRefund);
            return JsonResultUtil.createSuccessResultWithObj(trade_no);
        }
        return JsonResultUtil.createDefaultFail();
    }
}