package com.xxfc.platform.order.service;

import cn.hutool.core.util.IdUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractOrderHandle<Biz extends BaseBiz, Detail extends OrderDetail>{

    @Autowired
    protected Biz detailBiz;

    @Autowired
    protected BaseOrderBiz baseOrderBiz;

    protected OrderTypeEnum orderTypeEnum;

    /**
     * 创建基础订单
     * @return
     */
    public BaseOrder createOrder() {
        BaseOrder baseOrder = new BaseOrder();
        baseOrder.setNo(IdUtil.randomUUID());
        if(null == orderTypeEnum)
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        else {
            baseOrder.setType(orderTypeEnum.getCode());
        }
        return baseOrder;
    }

    /**
     * 创建订单及其子项
     * @param detail
     */
    public void createOrder(Detail detail) {
        BaseOrder order = createOrder();
        baseOrderBiz.insertSelective(order);
        createOrderMakeUp(order, detail);
        handleDetail(detail);
}

    /**
     * 处理订单子项
     * @param detail
     */
    public void handleDetail(Detail detail){
        detailBiz.insertSelective(detail);
    }

//    /**
//     * 创建订单及其多子项
//     * @param details
//     */
//    public void createOrder(List<Detail> details) {
//        BaseOrder order = createOrder();
//        for(Detail detail : details) {
//            createOrderMakeUp(order, detail);
//        }
//        handleDetail(details);
//    }
//
//    /**
//     * 处理订单多子项
//     * @param details
//     */
//    public void handleDetail(List<Detail> details){
//        for(Detail detail : details) {
//            detailBiz.insertSelective(detail);
//        }
//    }

    public void calculatePrice(Detail detail) {

    }

    /**
     * 子项补充处理
     * @param baseOrder
     * @param detail
     */
    void createOrderMakeUp(BaseOrder baseOrder, Detail detail){
        detail.setOrderId(baseOrder.getId());
    }


}
