package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.order.biz.OrderRentVehicleBiz;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.service.OrderRentVehicleService;
import com.xxfc.platform.order.vo.AddRentVehicleOrderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Controller
@RequestMapping("orderRentVehicle")
@Api(value="租车订单",tags={"租车订单"})
public class OrderRentVehicleController extends CommonBaseController {

        @Autowired
        OrderRentVehicleService orderRentVehicleService;

        @Autowired
        OrderRentVehicleBiz orderRentVehicleBiz;

        @RequestMapping(value = "add",method = RequestMethod.POST)
        @ResponseBody
        @ApiOperation(value = "确认租车订单")
        public ObjectRestResponse<OrderRentVehicleDetail> add(@RequestBody AddRentVehicleOrderVO vo){
            orderRentVehicleService.createOrder(vo);
            return new ObjectRestResponse<>();
        }

        @RequestMapping(value = "list-by-order/{orderId}",method = RequestMethod.GET)
        @ResponseBody
        @ApiOperation(value = "租车列表by订单Id")
        public ObjectRestResponse<OrderRentVehicleDetail> listByOrder(@PathVariable("orderId") Integer orderId){
                return new ObjectRestResponse<>().data(orderRentVehicleBiz.listByOrderId(orderId));
        }
}