package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.vo.OrderPageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

@Controller
@RequestMapping("baseOrder")
@Api(value="订单",tags={"订单"})
public class BaseOrderController extends CommonBaseController {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @RequestMapping(value = "/page",method = RequestMethod.GET)
    @ResponseBody
    @ApiOperation(value = "订单列表")
    public ObjectRestResponse<PageDataVO<OrderPageVO>> list(@RequestParam(required = false) Map<String, Object> params){
        //查询列表数据
        Query query = new Query(params);
        return new ObjectRestResponse<>().data(PageDataVO.pageInfo(1, 10, baseOrderBiz.pageByParm()));
    }
}