package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;


/**
 * 
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-24 21:56:10
 */
@Table(name = "base_order")
public class BaseOrder implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    //订单号
    @Column(name = "no")
	@ApiModelProperty(value = "订单号")
    private String no;
	
	    //订单类型
    @Column(name = "type")
	@ApiModelProperty(value = "订单类型")
    private Integer type;
	
	    //订单详情id
    @Column(name = "detail_id")
	@ApiModelProperty(value = "订单详情id")
    private Integer detailId;
	
	    //订单状态
    @Column(name = "status")
	@ApiModelProperty(value = "订单状态")
    private Integer status;
	
	    //商品价格
    @Column(name = "product_amount")
	@ApiModelProperty(value = "商品价格")
    private BigDecimal productAmount;
	
	    //实际价格
    @Column(name = "order_amount")
	@ApiModelProperty(value = "实际价格")
    private BigDecimal orderAmount;
	
	    //详情json信息
    @Column(name = "detail_json")
	@ApiModelProperty(value = "详情json信息")
    private String detailJson;
	
	    //第三方类型（支付渠道）
    @Column(name = "third_type")
	@ApiModelProperty(value = "第三方类型（支付渠道）")
    private Integer thirdType;
	
	    //流水号
    @Column(name = "out_trade_no")
	@ApiModelProperty(value = "流水号")
    private String outTradeNo;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    //创建者id
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private String crtUser;
	
	    //创建者名称
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建者名称")
    private String crtName;
	
	    //创建者ip
    @Column(name = "crt_host")
	@ApiModelProperty(value = "创建者ip")
    private String crtHost;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    //更新者id
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新者id")
    private String updUser;
	
	    //更新者名称
    @Column(name = "upd_name")
	@ApiModelProperty(value = "更新者名称")
    private String updName;
	
	    //更新者ip
    @Column(name = "upd_host")
	@ApiModelProperty(value = "更新者ip")
    private String updHost;
	

	/**
	 * 设置：主键
	 */
	public void setId(Integer id) {
		this.id = id;
	}
	/**
	 * 获取：主键
	 */
	public Integer getId() {
		return id;
	}
	/**
	 * 设置：订单号
	 */
	public void setNo(String no) {
		this.no = no;
	}
	/**
	 * 获取：订单号
	 */
	public String getNo() {
		return no;
	}
	/**
	 * 设置：订单类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	/**
	 * 获取：订单类型
	 */
	public Integer getType() {
		return type;
	}
	/**
	 * 设置：订单详情id
	 */
	public void setDetailId(Integer detailId) {
		this.detailId = detailId;
	}
	/**
	 * 获取：订单详情id
	 */
	public Integer getDetailId() {
		return detailId;
	}
	/**
	 * 设置：订单状态
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}
	/**
	 * 获取：订单状态
	 */
	public Integer getStatus() {
		return status;
	}
	/**
	 * 设置：商品价格
	 */
	public void setProductAmount(BigDecimal productAmount) {
		this.productAmount = productAmount;
	}
	/**
	 * 获取：商品价格
	 */
	public BigDecimal getProductAmount() {
		return productAmount;
	}
	/**
	 * 设置：实际价格
	 */
	public void setOrderAmount(BigDecimal orderAmount) {
		this.orderAmount = orderAmount;
	}
	/**
	 * 获取：实际价格
	 */
	public BigDecimal getOrderAmount() {
		return orderAmount;
	}
	/**
	 * 设置：详情json信息
	 */
	public void setDetailJson(String detailJson) {
		this.detailJson = detailJson;
	}
	/**
	 * 获取：详情json信息
	 */
	public String getDetailJson() {
		return detailJson;
	}
	/**
	 * 设置：第三方类型（支付渠道）
	 */
	public void setThirdType(Integer thirdType) {
		this.thirdType = thirdType;
	}
	/**
	 * 获取：第三方类型（支付渠道）
	 */
	public Integer getThirdType() {
		return thirdType;
	}
	/**
	 * 设置：流水号
	 */
	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}
	/**
	 * 获取：流水号
	 */
	public String getOutTradeNo() {
		return outTradeNo;
	}
	/**
	 * 设置：创建时间
	 */
	public void setCrtTime(Date crtTime) {
		this.crtTime = crtTime;
	}
	/**
	 * 获取：创建时间
	 */
	public Date getCrtTime() {
		return crtTime;
	}
	/**
	 * 设置：创建者id
	 */
	public void setCrtUser(String crtUser) {
		this.crtUser = crtUser;
	}
	/**
	 * 获取：创建者id
	 */
	public String getCrtUser() {
		return crtUser;
	}
	/**
	 * 设置：创建者名称
	 */
	public void setCrtName(String crtName) {
		this.crtName = crtName;
	}
	/**
	 * 获取：创建者名称
	 */
	public String getCrtName() {
		return crtName;
	}
	/**
	 * 设置：创建者ip
	 */
	public void setCrtHost(String crtHost) {
		this.crtHost = crtHost;
	}
	/**
	 * 获取：创建者ip
	 */
	public String getCrtHost() {
		return crtHost;
	}
	/**
	 * 设置：更新时间
	 */
	public void setUpdTime(Date updTime) {
		this.updTime = updTime;
	}
	/**
	 * 获取：更新时间
	 */
	public Date getUpdTime() {
		return updTime;
	}
	/**
	 * 设置：更新者id
	 */
	public void setUpdUser(String updUser) {
		this.updUser = updUser;
	}
	/**
	 * 获取：更新者id
	 */
	public String getUpdUser() {
		return updUser;
	}
	/**
	 * 设置：更新者名称
	 */
	public void setUpdName(String updName) {
		this.updName = updName;
	}
	/**
	 * 获取：更新者名称
	 */
	public String getUpdName() {
		return updName;
	}
	/**
	 * 设置：更新者ip
	 */
	public void setUpdHost(String updHost) {
		this.updHost = updHost;
	}
	/**
	 * 获取：更新者ip
	 */
	public String getUpdHost() {
		return updHost;
	}
}
