package com.xxfc.platform.vehicle.biz;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.VehicleUserScore;
import com.xxfc.platform.vehicle.mapper.VehicleUserScoreMapper;
import com.xxfc.platform.vehicle.pojo.dto.ScoreTypeDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleUserScoreDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleUserScoreVo;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import java.time.Instant;
import java.util.List;


/**
 * 用户评分表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-18 15:03:58
 */
@Service
public class VehicleUserScoreBiz extends BaseBiz<VehicleUserScoreMapper, VehicleUserScore> {


    /**
     * 根据车型id查询
     * @param modelId
     * @return
     */
    public PageDataVO<VehicleUserScoreVo> findVehicleUserScorePageByModelId(Integer modelId) {
        return null;
    }

    /**
     * 保存评分
     * @param vehicleUserScoreDTO
     * @return
     */
    public int saveVehicleUserScore(VehicleUserScoreDTO vehicleUserScoreDTO) {
        vehicleUserScoreDTO.setCrtTime(Instant.now().toEpochMilli());
        List<ScoreTypeDTO> scoretype = vehicleUserScoreDTO.getScoretype();
        vehicleUserScoreDTO.setComment(JSONObject.toJSONString(scoretype));
        double avgScore = scoretype.stream().mapToInt(ScoreTypeDTO::getScore).average().getAsDouble();
        VehicleUserScore vehicleUserScore = new VehicleUserScore();
        BeanUtils.copyProperties(vehicleUserScoreDTO,vehicleUserScore);
        //vehicleUserScore.setAveScore();
        return mapper.insertSelective(vehicleUserScore);
    }
}