package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRefund;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.mapper.BaseOrderMapper;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

/**
 * 
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-15 21:30:33
 */
@Service
public class BaseOrderBiz extends BaseBiz<BaseOrderMapper,BaseOrder> {

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderRefundBiz orderRefundBiz;

    @Autowired
    ThirdFeign thirdFeign;

    public List<OrderPageVO> pageByParm(Map<String, Object> paramMap){
        return mapper.pageByParm(paramMap);
    }
    public List<OrderPageVO> listOrder(Map<String, Object> paramMap){
        return mapper.listOrder(paramMap);
    }
    private static Map<Integer, List<Integer>> cancelAble;
    static {
        cancelAble = new HashMap<Integer, List<Integer>>();
        cancelAble.put(OrderTypeEnum.RentVehicle.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
        }});
        cancelAble.put(OrderTypeEnum.TOUR.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
        }});
    }

    public void cancel(BaseOrder baseOrder) {
        if(cancelAble.get(baseOrder.getType()).contains(baseOrder.getStatus())) {
            this.updateSelectiveById(new BaseOrder(){{
                setId(baseOrder.getId());
                setStatus(OrderStatusEnum.ORDER_CANCEL.getCode());
                setCancelReason(baseOrder.getCancelReason());
            }});

            //触发退款流程
                //判断是否已支付
            if(baseOrder.getHasPay().equals(SYS_TRUE)) {
                //判断订单类型
                if(OrderTypeEnum.RentVehicle.getCode().equals(baseOrder.getType())) {
                    OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail(){{
                        setOrderId(baseOrder.getId());
                    }});
                    //计算退款金额
                        // 1、押金 + 租金(规则扣除)
                        BigDecimal refundAmont = orvd.getDeposit().add(baseOrder.getGoodsAmount());
                        thirdFeign.refund(new OrderRefundVo(){{
                            setAmount(baseOrder.getRealAmount().multiply(new BigDecimal("100")).intValue());
                            setRefundAmount(refundAmont.multiply(new BigDecimal("100")).intValue());
                            setOrderNo(baseOrder.getNo());
                            setRefundDesc("取消订单退款:"+ refundAmont.toString());
                        }});

                        //创建订单退款记录


                }else if (OrderTypeEnum.TOUR.getCode().equals(baseOrder.getType())) {

                }
            }
        }else {
            throw new BaseException(ResultCode.FAILED_CODE);
        }
    }
}