package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单退款记录表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 11:08:09
 */
@Data
@Table(name = "order_refund")
public class OrderRefund implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	
	    /**
     *  退款对应的流水号
     */
    @Column(name = "trade_no")
	@ApiModelProperty(value = "退款对应的流水号")
    private Integer tradeNo;
	
	    /**
     *  退款时间
     */
    @Column(name = "refund_time")
	@ApiModelProperty(value = "退款时间")
    private Long refundTime;
	
	    /**
     *  退款类型 1--订单款；2--押金
     */
    @Column(name = "refund_type")
	@ApiModelProperty(value = "退款类型 1--订单款；2--押金")
    private Integer refundType;
	
	    /**
     *  退款状态 0--失败；1--成功
     */
    @Column(name = "refund_status")
	@ApiModelProperty(value = "退款状态 0--失败；1--成功")
    private Integer refundStatus;
	
	    /**
     *  退款金额
     */
    @Column(name = "refund_amount")
	@ApiModelProperty(value = "退款金额")
    private Integer refundAmount;
	
	    /**
     *  退款说明
     */
    @Column(name = "refund_desc")
	@ApiModelProperty(value = "退款说明")
    private String refundDesc;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	

}
