package com.xxfc.platform.campsite.mapper;

import com.xxfc.platform.campsite.entity.CampsiteShopTag;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteShopTagMapper extends Mapper<CampsiteShopTag> {

    /**
     * 根据店铺id查询
     * @param shopId
     * @return
     */
    @Select("select `name` from campsite_shop_tag as `cst` left join campsite_tag as `ct` on cst.tag_id=ct.id where `shop_id`=#{shopId}")
    List<String> findByCampsiteShopId(Integer shopId);
}
