package com.xxfc.platform.campsite;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;
import tk.mybatis.spring.annotation.MapperScan;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/17 10:51
 */
@SpringBootApplication(scanBasePackages = {
        "com.xxfc.platform",
        "com.github.wxiaoqi.*"
})
@EnableDiscoveryClient
@EnableAceAuthClient
@EnableScheduling
@EnableFeignClients({"com.github.wxiaoqi.security.auth.client.feign", "com.github.wxiaoqi.security.admin.feign","com.xxfc.platform"})
@EnableAceCache
@EnableCaching
@MapperScan(basePackages = "com.xxfc.platform.campsite.mapper")
public class CampSiteApplication {
    public static void main(String[] args) {
        SpringApplication.run(CampSiteApplication.class,args);
    }
}
