package com.xxfc.platform.campsite.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 店铺详情vo
 * @data 2019/6/17 17:35
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "店铺详情")
public class CampsiteShopDetailVo {

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String name;

    /**
     * 具体地址
     */
    @ApiModelProperty("具体地址")
    private String address;

    /**
     * 店铺详情
     */
    @ApiModelProperty("店铺详情")
    private String content;

    /**
     * 配套设施&收费
     */
    @ApiModelProperty("配套设施&收费")
    private String configure;

    /**
     * 距离
     */
    @ApiModelProperty("距离")
    private String distance;

    /**
     * 类型列表
     *
     */
    @ApiModelProperty("类型列表")
    private String typeNames;

    /**
     *轮播图列表
     */
    @ApiModelProperty("轮播图列表")
    private List<CampsiteShopCarouselDetailVo> campsiteShopCarouselDetailVos;
}
