package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 会员等级表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-11 11:06:45
 */
@Data
@Table(name = "base_user_member_level")
public class BaseUserMemberLevel implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键id
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    //等级名称
    @Column(name = "name")
	@ApiModelProperty(value = "等级名称")
    private String name;
	
	    //图标
    @Column(name = "icon")
	@ApiModelProperty(value = "图标")
    private String icon;
	
	    //等级
    @Column(name = "level")
	@ApiModelProperty(value = "等级")
    private Integer level;
	
	    //描述
    @Column(name = "describes")
	@ApiModelProperty(value = "描述")
    private String describe;
	
	    //有效数；-1是永久有效
    @Column(name = "end_date")
	@ApiModelProperty(value = "有效数；-1是永久有效")
    private Integer endDate;
	
	    //折扣
    @Column(name = "discount")
	@ApiModelProperty(value = "折扣")
    private Integer discount;
	
	    //是否删除；0-正常；1-删除
    @Column(name = "isdel")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isdel;
	
	    //购买会员价格
    @Column(name = "price")
	@ApiModelProperty(value = "购买会员价格")
    private BigDecimal price;
	

}
