package com.github.wxiaoqi.security.common.util.result;

import java.io.Serializable;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.util.SystemProperty;
import com.github.wxiaoqi.security.common.util.process.ResultCode;


/**
 * 返回操作结果
 * @author Czz
 *
 */
public final class JsonResultUtil implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private static final Integer WEB_CALL_RESULT_SUCCESS = ResultCode.SUCCESS_CODE;
	private static final Integer WEB_CALL_RESULT_FAILED = ResultCode.FAILED_CODE;
	private static final String RESULT_KEY_TYPE = "status";
	private static final String RESULT_KEY_MSG = "message";
	private static final String RESULT_SUCCESS_MSG = "操作成功";
	private static final String RESULT_FAIL_MSG = "操作失败";
	private static final String DATA_KEY = "data";
	
	public static final JSONObject SUCCESS_RESULT_JSON = new JSONObject();
	
	private static final JSONObject FAIL_RESULT_JSON = new JSONObject();
	
	static {
		/**
		 * 默认成功初始化
		 */
		SUCCESS_RESULT_JSON.put(RESULT_KEY_TYPE, WEB_CALL_RESULT_SUCCESS);
		SUCCESS_RESULT_JSON.put(RESULT_KEY_MSG, RESULT_SUCCESS_MSG);
		/**
		 * 默认失败初始化
		 */
		FAIL_RESULT_JSON.put(RESULT_KEY_TYPE, WEB_CALL_RESULT_FAILED);
		FAIL_RESULT_JSON.put(RESULT_KEY_MSG, RESULT_FAIL_MSG);
	}
	
	/**
	 * 创建一个正确的调用结果
	 * @return
	 */
	public static JSONObject createSuccessResult() {
		return SUCCESS_RESULT_JSON;
	}
	
	/**
	 * 
	 * @Description: 创建一个没有错误信息的失败返回
	 * @return
	 * @throws
	 */
	public static JSONObject createDefaultFail() {
		return FAIL_RESULT_JSON;
	}
	
	/**
	 * 
	 * @Description: 创建一个带一个键值对对象的正确调用结果
	 * @param value
	 * @return
	 * @throws
	 */
	public static JSONObject createSuccessResultWithObj(final Object value) {
		JSONObject successJson = new JSONObject();
		successJson.put(RESULT_KEY_TYPE, WEB_CALL_RESULT_SUCCESS);
		successJson.put(RESULT_KEY_MSG, RESULT_SUCCESS_MSG);
		successJson.put(DATA_KEY, value);
		return successJson;
	}
	
	/**
	 * 创建一个异常的调用结果
	 * @param message
	 * @return
	 */
	public static JSONObject createFailedResult(int code, String message) {
		JSONObject failedResult = new JSONObject();
		failedResult.put(RESULT_KEY_TYPE, code);
		failedResult.put(RESULT_KEY_MSG, message);
		return failedResult;
	}
	
	
	/**
	 * 创建一个异常的调用结果并携带结果参数
	 * @param message
	 * @return
	 */
	public static JSONObject createFailedResult(int code, String message,final Object value) {
		JSONObject failedResult = new JSONObject();
		failedResult.put(RESULT_KEY_TYPE, code);
		failedResult.put(RESULT_KEY_MSG, message);
		failedResult.put(DATA_KEY, value);
		return failedResult;
	}
	
	/**
	 * 创建一个异常的调用结果，根据code获取对应的提示
	 * @param code
	 * @return
	 */
	public static JSONObject createFailedResultMsg(int code) {
		JSONObject failedResult = new JSONObject();
		failedResult.put(RESULT_KEY_TYPE, code);
		failedResult.put(RESULT_KEY_MSG, SystemProperty.getResultConfig(code + ""));
		return failedResult;
	}


}
