package com.xxfc.platform.activity.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.entity.IntegralUserTotal;
import com.xxfc.platform.activity.mapper.IntegralUserTotalMapper;
import com.xxfc.platform.activity.user.UserInfoBiz;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class IntegralUserTotalBiz extends BaseBiz<IntegralUserTotalMapper, IntegralUserTotal> {

    @Autowired
    UserInfoBiz userInfoBiz;

    /**
     * 添加用户总积分
     * @param integralUserTotal
     * @return
     */
    public ObjectRestResponse  add(IntegralUserTotal integralUserTotal) {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        if(integralUserTotal == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        integralUserTotal.setUserId(appUserDTO.getUserid());
        if(integralUserTotal.getId() != null) {
            IntegralUserTotal oldValue = mapper.selectByPrimaryKey(integralUserTotal.getId());
            if(oldValue == null) {
                return ObjectRestResponse.createDefaultFail();
            }
            BeanUtil.copyProperties(integralUserTotal, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            mapper.updateByPrimaryKeySelective(oldValue);
            return ObjectRestResponse.succ();
        }
        mapper.insertSelective(integralUserTotal);
        return ObjectRestResponse.succ();
    }

    /**
     * 删除信息
     * @param id
     * @return
     */
    public ObjectRestResponse deleteOne() {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        IntegralUserTotal integralUserTotal = new IntegralUserTotal();
        integralUserTotal.setUserId(appUserDTO.getUserid());
        List<IntegralUserTotal> oldValue = mapper.selectAllByParam(integralUserTotal);
        if(oldValue == null || oldValue.size() <= 0) {
            return ObjectRestResponse.createDefaultFail();
        }
        oldValue.get(0).setIsdel(true);
        mapper.updateByPrimaryKeySelective(oldValue.get(0));
        return ObjectRestResponse.succ();
    }

    /**
     * 获取某个用户的积分信息
     * @return
     */
    public ObjectRestResponse<IntegralUserTotal> getByUser() {
        AppUserDTO appUserDTO = userInfoBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        IntegralUserTotal integralUserTotal = new IntegralUserTotal();
        integralUserTotal.setUserId(appUserDTO.getUserid());
        List<IntegralUserTotal> oldValue = mapper.selectAllByParam(integralUserTotal);
        if(oldValue == null || oldValue.size() <= 0) {
            return ObjectRestResponse.createDefaultFail();
        }
        return ObjectRestResponse.succ(oldValue.get(0));
    }

    /**
     * 获取所有的信息
     * @param integralUserTotal
     * @return
     */
    public ObjectRestResponse<List<IntegralUserTotal>> getAll(IntegralUserTotal integralUserTotal) {
        List<IntegralUserTotal> integralUserTotals = mapper.selectAllByParam(integralUserTotal);
        return ObjectRestResponse.succ(integralUserTotals);
    }

}
