package com.xxfc.platform.activity.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.entity.IntegralRule;
import com.xxfc.platform.activity.mapper.IntegralRuleMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class IntegralRuleBiz extends BaseBiz<IntegralRuleMapper, IntegralRule> {


    /**
     * 添加、更新积分规则
     * @param integralRule
     * @return
     */
    public ObjectRestResponse add(IntegralRule integralRule) {
        if(integralRule == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        if(integralRule.getId() != null) {//已存在，更新
            IntegralRule oldValue = mapper.selectByPrimaryKey(integralRule.getId());
            if(oldValue == null) {
                return ObjectRestResponse.createDefaultFail();
            }
            BeanUtil.copyProperties(integralRule, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            mapper.updateByPrimaryKeySelective(oldValue);
            return ObjectRestResponse.succ();
        }
        mapper.insertSelective(integralRule);
        return ObjectRestResponse.succ();
    }

    /**
     * 删除积分规则
     * @param id
     * @return
     */
    public ObjectRestResponse deleteOne(Integer id) {
        if(id == null || id < 0) {
            return ObjectRestResponse.paramIsEmpty();
        }
        IntegralRule oldValue = mapper.selectByPrimaryKey(id);
        if(oldValue == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        oldValue.setIsdel(true);
        mapper.updateByPrimaryKeySelective(oldValue);
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse<IntegralRule> getOne(IntegralRule integralRule) {
        if(integralRule == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        IntegralRule oldValue = mapper.selectByPrimaryKey(integralRule.getId());
        if(oldValue == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        return ObjectRestResponse.succ(oldValue);
    }


    public ObjectRestResponse<List<IntegralRule>>  getAll(IntegralRule integralRule) {
        List<IntegralRule> integralRules = mapper.selectAllByParam(integralRule);
        return ObjectRestResponse.succ(integralRules);
    }


}
