package com.github.wxiaoqi.security.admin.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.biz.AppUserManageBiz;
import com.github.wxiaoqi.security.admin.dto.AppUserManageDTO;
import com.github.wxiaoqi.security.admin.dto.BaseUserMemberVO;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.vo.AppUserManageVo;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * app用户管理类
 * @author Administrator
 */
@RestController
@RequestMapping("appUsersManage")
public class AppUsersManageController extends BaseController<AppUserManageBiz,AppUserManage> {

    /**
     * 查询所有
     * @return
     */
    @PostMapping("/findAll")
    public ObjectRestResponse<List<AppUserManageVo>> findAllByQuery(@RequestBody AppUserManageDTO appUserManageDTO){
        return ObjectRestResponse.succ(baseBiz.findAllByQuery(appUserManageDTO));
    }

    /**
     * 禁用
     * @param id
     * @return
     */
    @DeleteMapping("/deleteById/{id}/{isDel}")
    public  ObjectRestResponse deleteById(@PathVariable Integer id,@PathVariable Integer isDel){
          baseBiz.deleteAppUser(id,isDel);
        return ObjectRestResponse.succ();
    }

    /**
     * 查询一条
     * @param id
     * @return
     */
    @GetMapping("/findOneById/{id}")
    public ObjectRestResponse<AppUserVo> findOneById(@PathVariable Integer id){
        return ObjectRestResponse.succ(baseBiz.findOneById(id));
    }

    /**
     * 保存
     * @param appUserVo
     * @return
     */
    @PostMapping("/save")
    public ObjectRestResponse save(@RequestBody AppUserVo  appUserVo){
        baseBiz.save(appUserVo);
        return ObjectRestResponse.succ();
    }


}
