package com.xxfc.platform.app.biz;

import com.github.wxiaoqi.security.common.constant.RestCode;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.xxfc.platform.app.entity.AppVersion;
import com.xxfc.platform.app.mapper.AppVersionMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-24 10:34:00
 */
@Service
public class AppVersionBiz extends BaseBiz<AppVersionMapper,AppVersion> {


    public ObjectRestResponse getVersion(String version,Integer type){
        if (StringUtils.isBlank(version)||type==null){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        version=version.trim();
        Example example =new Example(AppVersion.class);
        example.createCriteria().andEqualTo("isDel",0).andEqualTo("downloadSwitch",0).andEqualTo("sysType",type);
        example.setOrderByClause("version DESC");
        List<AppVersion> list=selectByExample(example);
        example.clear();
        example.createCriteria().andEqualTo("version",version).andEqualTo("sysType",type);
        List<AppVersion> list1=selectByExample(example);
        Integer weigh1=0;
        if(list1.size()>0){
            weigh1=list1.get(0).getWeigh();
        }
        if (list.size()>0){
            AppVersion appVersion=list.get(0);
            String lats_version=appVersion.getVersion();
            Integer weigh=appVersion.getWeigh();
            if(!version.equals(lats_version)&&weigh>weigh1){
                return new ObjectRestResponse().status(RestCode.SUCCESS.getStatus()).msg(RestCode.SUCCESS.getMsg()).data(appVersion).rel(false);
            }
        }
           return  ObjectRestResponse.succ();
    }
}