package com.xxfc.platform.vehicle.biz;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.entity.Constant;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.mapper.VehicleMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class ImportVehicleDataBiz extends BaseBiz<VehicleMapper, Vehicle> {
    @Autowired
    private ConstantBiz constantBiz;

    @Transactional(rollbackFor = Exception.class)
    public Object parsingUploadedFiles(List<List<Object>> excel) {
        try {

            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < excel.size(); i++) {

                System.out.println(i);
                List<Object> list = excel.get(i);
                //获取车牌号
                String numberPlate = (String) list.get(2);
                if (StringUtils.isBlank(numberPlate)) {
                    continue;
                }
                Example example = new Example(Vehicle.class);
                example.createCriteria().andEqualTo("numberPlate", numberPlate);
                List<Vehicle> vehicles = mapper.selectByExample(example);
                if (CollectionUtils.isEmpty(vehicles)) {
                    stringBuffer.append(numberPlate).append(",");
                    continue;
                }

                Example example1 = new Example(Constant.class);
                example1.createCriteria().andEqualTo("type", 3);
                List<Constant> constants = constantBiz.selectByExample(example1);

                for (Vehicle vehicle : vehicles) {
                    if (i==83){
                        System.out.println("测试");
                    }
                    log.info("修改前:" + vehicle.toString());
                    if (numberPlate.equals(vehicle.getNumberPlate()) && !( String.valueOf(list.get(1)).equals(vehicle.getCode()))) {
                        stringBuffer2.append("numberPlate:" + numberPlate).append(",").append("code:" + ((String) list.get(2))).append("|");
                    }

                    //设置托管人
                    if (list.get(5) != null) {
                        vehicle.setBelongTo(2);
                        vehicle.setBelongToName((String) list.get(5));
                    }


                    //设置车架号
                    if (list.get(6) != null) {
                        vehicle.setVin((String) list.get(6));
                    }


//                    //设置交强险公司
//                    if (list.get(7) != null && !((String) list.get(7)).trim().equals("未知")) {
//                        String company = (String) list.get(7);
//                        for (Constant constant : constants) {
//                            if (constant.getVal().contains(company)) {
//                                vehicle.setStrongInsuranceCompany(constant.getCode());
//                                break;
//                            }
//                        }
//
//
//                    }
//
//                    //设置交强险单号
//                    if (list.get(8) != null) {
//                        vehicle.setStrongInsuranceNo((String) list.get(8));
//                    }
//
//                    //设置交强险到期时间
//                    if ((list.get(9) != null) && String.valueOf(list.get(9)).trim() != "") {
//                        vehicle.setStrongInsuranceEndDate(((DateTime) list.get(9)).toJdkDate());
//                    }

                    //设置商业险公司
                    if (list.get(10) != null) {
                        String company = (String) list.get(10);

                        for (Constant constant : constants) {
                            if (constant.getVal().contains(company)) {
                                vehicle.setInsuranceCompany(constant.getCode());
                                break;
                            }
                        }
                    }

                    //设置商业险单号
                    if (list.get(11) != null) {
                        vehicle.setInsuranceNo((String) list.get(11));
                    }
                    //设置商业险到期时间
                    if (list.get(12) != null&&String.valueOf(list.get(12)).trim()!="") {
                        vehicle.setInsuranceEndDate(((DateTime) list.get(12)).toJdkDate());
                    }


                    //设置年审时间
                    if (list.get(13) != null&&String.valueOf(list.get(13)).trim()!="") {
                        DateTime dateTime = (DateTime) list.get(13);
                        vehicle.setAnnualVerificationDate(dateTime.toJdkDate());
                    }

                    //设置发动机号
                    if (list.get(14) != null) {
                        vehicle.setEngineNum(String.valueOf(list.get(14)) );
                    }

                    System.out.println(i);
                    log.info("修改后:" + vehicle.toString());
                    mapper.updateByPrimaryKeySelective(vehicle);
                }

            }
            System.out.println("stringBuffer:"+stringBuffer);
            System.out.println("stringBuffer2:"+stringBuffer2);
        } catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return null;
    }

}
