package com.xxfc.platform.app.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * Demo class
 *
 * @author zuoyh
 * @date 2020/1/10
 */
@Data
@Table(name = "app_version_mark")
public class AppVersionMark implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * app版本标识信息表ID
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("app版本信息表")
    private Integer id;

    /**
     * 标识
     */
    @Column(name = "mark")
    @ApiModelProperty(value = "标识")
    private String mark;

    /**
     * 标识名称
     */
    @Column(name = "mark_name")
    @ApiModelProperty(value = "标识名称")
    private String markName;

    /**
     * 标识描述
     */
    @Column(name = "mark_remark")
    @ApiModelProperty(value = "标识描述")
    private String markRemark;

    /**
     * 是否删除；0-正常；1-删除
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;

    /**
     * 版本标识上传时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "版本上传时间", hidden = true)
    private Date crtTime;

    /**
     * 版本标识更新时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "版本标识更新时间", hidden = true)
    private Long updTime;


    /**
     * 版本标识来源类型
     */
    @Column(name = "source_type")
    @ApiModelProperty(value = "版本标识更新时间", hidden = true)
    private String  sourceType;

}
