package com.xxfc.platform.universal;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableDiscoveryClient
@EnableAceAuthClient
@EnableAceCache
@EnableTransactionManagement
@tk.mybatis.spring.annotation.MapperScan(basePackages = "com.xxfc.platform.universal.mapper")
@EnableFeignClients({"com.github.wxiaoqi.security.auth.client.feign", "com.xxfc.platform","com.github.wxiaoqi.security.admin.feign"})
public class UniversalApplication {

    public static void main(String[] args) {
        SpringApplication.run(UniversalApplication.class, args);
    }
}
