package com.xxfc.platform.tour.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourTagBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.dto.TourTagAndBannerDTO;
import com.xxfc.platform.tour.entity.TourTag;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;


/**
 * @author libin
 * @version 1.0
 * @description 旅游标签
 * @data 2019/6/11 9:57
 */
@RestController
@RequestMapping("/admin/tourTag")
@Api(value = "后台*旅游标签")
public class TourTagAdminController extends TourBaseController<TourTagBiz> {
    /**
     * 分页查询标签
     *
     * @param pageNo   访问页
     * @param pageSize 分页大小
     * @return
     */
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "pageNo",paramType = "query",dataType = "integer",defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize",paramType = "query",dataType = "integer",defaultValue = "10")
    })
    @ApiOperation(value = "旅游标签分页查询")
    @ApiResponse(code = 200,message = "Success")
    @GetMapping("/pages")
    public ObjectRestResponse<PageDataVO> findTourTageWithPage(@RequestParam(name = "pageNoe", defaultValue = "0",required = false) Integer pageNo,
                                                               @RequestParam(name = "pageSize", defaultValue = "10",required = false) Integer pageSize) {
        PageDataVO<TourTagAndBannerDTO> pageDataVO = getBaseBiz().findTourTagWithPage(pageNo, pageSize);
        return ObjectRestResponse.succ(pageDataVO);
    }

    /**
     * 根据 id 查询旅游标签
     * @param id
     * @return
     */
   @GetMapping("/findById/{id}")
   @ApiOperation(value = "根据id查询旅游标签")
    public ObjectRestResponse<TourTagAndBannerDTO> findTourTagById(@PathVariable int id) {
        TourTagAndBannerDTO tourTag = getBaseBiz().findTourTagById(id);
     return ObjectRestResponse.succ(tourTag);
    }

    /**
     * 保存旅游标签
     * @param tourTagAndBannerDTO
     * @return
     */
    @PostMapping("/save")
    @ApiOperation("保存旅游标签")
    public ObjectRestResponse<TourTag> save(@RequestBody TourTagAndBannerDTO tourTagAndBannerDTO) {
        int insertRows = getBaseBiz().saveTourTag(tourTagAndBannerDTO,getUserInfo());
        if (insertRows>0){
            return  ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    /**
     * 逻辑删除
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation("逻辑删除旅游标签")
    public ObjectRestResponse<TourTag> remove(@PathVariable int id) {
        int effRow = getBaseBiz().updateTourTagStateById(id,1);
        if (effRow>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    /**
     * 修改旅游标签信息
     * @return
     */
    @PutMapping("/update")
    @ApiOperation("更新旅游标签")
    public ObjectRestResponse<Void> updateTourTag(@RequestBody TourTagAndBannerDTO tourTagAndBannerDTO){
        int effectRows = getBaseBiz().updateTourTag(tourTagAndBannerDTO,getUserInfo());
        if (effectRows>0) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }
}