package com.xxfc.platform.tour.rest.admin;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.tour.biz.TourGoodBiz;
import com.xxfc.platform.tour.dto.GoodSearchDTO;
import com.xxfc.platform.tour.dto.TourGoodDTO;
import com.xxfc.platform.tour.entity.TourGood;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("good")
@IgnoreClientToken
public class TourGoodAdminController extends BaseController<TourGoodBiz, TourGood> {

    @ApiOperation("后台查询旅游路线列表")
    @RequestMapping(value = "/admin/goodList", method = RequestMethod.GET)
    public ObjectRestResponse<TourGood> goodList(@RequestBody GoodSearchDTO dto) {
        return ObjectRestResponse.succ(baseBiz.getAll(dto));
    }

    @ApiOperation("后台查询旅游路线列表")
    @RequestMapping(value = "/admin/goodEdit", method = RequestMethod.GET)
    public ObjectRestResponse<TourGood> goodEdit(@RequestBody TourGoodDTO dto) {
        return ObjectRestResponse.succ(baseBiz.goodsEdit(dto));
    }


}