package com.xxfc.platform.tour.biz;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.util.EntityUtils;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.dto.TourTagBannerDTO;
import com.xxfc.platform.tour.mapper.TourTagBannerMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.tour.entity.TourTagBanner;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

/**
 * 标签轮播图
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
public class TourTagBannerBiz extends BaseBiz<TourTagBannerMapper,TourTagBanner> {


    public List<TourTagBanner> findById(long tid) {

        TourTagBanner tourTagBanner = new TourTagBanner();
        tourTagBanner.setId(tid);
        tourTagBanner.setIsDel(0);
        return  mapper.select(tourTagBanner);
    }


    /**
     * 分页查询旅游标签banner数据
     * @param pageNo
     * @param pageSize
     * @return
     */
    public PageDataVO<TourTagBanner> findTourTagBannerWithPage(Integer pageNo,Integer pageSize){

        return  PageDataVO.pageInfo(pageNo,pageSize,()->mapper.findAllByState(0));
    }

    /**
     * 根据id更改banner状态
     * @param id
     * @param status
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public int updateTourTagBannerStatusById(int id, int status) {

        return mapper.updateTourTagBannerStatusById(id,status);
    }

    /**
     * 保存标签轮播图
     * @param tourTagBannerDTO
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public int save(TourTagBannerDTO tourTagBannerDTO, AppUserDTO appUserDTO) {
        TourTagBanner tourTagBanner = new TourTagBanner();
        BeanUtils.copyProperties(tourTagBannerDTO,tourTagBanner);
        //设置相关信息
        tourTagBanner.setCrtTime(Instant.now().toEpochMilli());
        tourTagBanner.setCrtName(appUserDTO.getRealname()==null?appUserDTO.getNickname():appUserDTO.getRealname());
        return mapper.insert(tourTagBanner);
    }

    /**
     * 根据标签id查询
     * @param tagId
     * @return
     */
    public List<TourTagBannerDTO> findTourTagBannersByTagId(Integer tagId) {
        List<TourTagBanner> tourTagBanners =  mapper.findByTagId(tagId);
        List<TourTagBannerDTO> tourTagBannerDTOS = new ArrayList<>(tourTagBanners.size());
        for (TourTagBanner tourTagBanner : tourTagBanners) {
            TourTagBannerDTO tourTagBannerDTO = new TourTagBannerDTO();
            BeanUtils.copyProperties(tourTagBanner,tourTagBannerDTO);
            tourTagBannerDTOS.add(tourTagBannerDTO);
        }
        return tourTagBannerDTOS;
    }

    /**
     *根据标签id更改banner状态
     * @param tagId
     * @param status
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public int updateTourTagBannerStatusByTagId(Integer tagId, int status) {
      return  mapper.updateTourTagBannerStatusByTagId(tagId,status,Instant.now().toEpochMilli());
    }

    /**
     * 批量更新banner信息
     * @param tourTagBannerDTOS
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateTourBannerByBatch(List<TourTagBannerDTO> tourTagBannerDTOS,AppUserDTO appUserDTO) {
        tourTagBannerDTOS.stream().peek(tourTagBannerDTO -> EntityUtils.setUpdatedInfo(tourTagBannerDTO)).forEach(tourTagBannerDTO -> {
            updateTourBanner(tourTagBannerDTO,appUserDTO);
        });
    }

    /**
     * 更改banner信息
     * @param tourTagBannerDTO
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public int updateTourBanner(TourTagBannerDTO tourTagBannerDTO,AppUserDTO appUserDTO){
        tourTagBannerDTO.setUpdName(appUserDTO.getRealname()==null?appUserDTO.getNickname():appUserDTO.getRealname());
        tourTagBannerDTO.setUpdTime(Instant.now().toEpochMilli());
        return mapper.updateTourTagBanner(tourTagBannerDTO);
    }
}