package com.xxfc.platform.tour.biz;

import com.ace.cache.annotation.CacheClear;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.comstnt.RedisKey;
import com.xxfc.platform.tour.mapper.TourBannerMapper;
import org.springframework.stereotype.Service;
import com.xxfc.platform.tour.entity.TourBanner;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.time.Instant;
import java.util.List;

/**
 * 首页banner图
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
public class TourBannerBiz extends BaseBiz<TourBannerMapper,TourBanner> {

    @CacheClear(key = RedisKey.CONSTANT_CODE_PREFIX_BANNER)
    public void update(TourBanner banner) {
      this.updateSelectiveById(banner);
    }


    @CacheClear(key = RedisKey.CONSTANT_CODE_PREFIX_BANNER)
    public void remove(int id) {
        this.deleteById(id);
    }

    public List<TourBanner> findBannerList() {
        TourBanner banner = new TourBanner();
        banner.setIsDel(0);
        return  mapper.findBannerListByisDelOrderByRank(banner);
    }

    /**
     * 更改banner信息
     * @param banner
     * @param userInfo
     * @return
     */
    public int update(TourBanner banner, AppUserDTO userInfo) {
         banner.setUpdName(userInfo.getRealname()==null?userInfo.getNickname():userInfo.getRealname());
         banner.setUpdTime(Instant.now().toEpochMilli());
      return  mapper.updateByPrimaryKeySelective(banner);
    }

    /**
     * 分页查询banner
     * @param pageNo
     * @param pageSize
     * @return
     */
    public PageDataVO<TourBanner> findBannePage(Integer pageNo, Integer pageSize) {
        return  PageDataVO.pageInfo(pageNo, pageSize, () -> mapper.findBannerListByisDelOrderByRank(TourBanner.builder().isDel(0).build()));
    }


    /**
     * 保存banner
     * @param banner
     * @param userInfo
     * @return
     */
    public int save(TourBanner banner, AppUserDTO userInfo) {
         banner.setCrtName(userInfo.getRealname()==null?userInfo.getNickname():userInfo.getRealname());
         banner.setCrtTime(Instant.now().toEpochMilli());
         return mapper.insert(banner);
    }

    /**
     * 逻辑删除
     * @param id
     * @param status
     * @param userInfo
     * @return
     */
    public int updateBannerStatus(Integer id, int status, AppUserDTO userInfo) {
        String crtName  = userInfo.getRealname() == null ? userInfo.getNickname() : userInfo.getRealname();
        return  mapper.updateByPrimaryKeySelective(TourBanner.builder().id(Long.valueOf(id)).isDel(status).updName(crtName).updTime(Instant.now().toEpochMilli()).build());
    }
}