package com.xxfc.platform.summit.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.summit.dto.ActivityShowDto;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.entity.ActivityShow;
import com.xxfc.platform.summit.mapper.ActivityShowMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.annotation.GetMapping;
import sun.rmi.runtime.Log;

import java.lang.reflect.InvocationTargetException;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class ActivityShowBiz extends BaseBiz<ActivityShowMapper, ActivityShow> {

    @Autowired
    private ActivityBiz activityBiz;

    public ActivityShowDto getOne(Integer activityId) {
        ActivityShow activityShow = new ActivityShow();
        activityShow.setActivityId(activityId);
        return mapper.getOne(activityId);
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean save(ActivityShowDto showDto) {
        try {
            ActivityShow activityShow = new ActivityShow();
            BeanUtilsBean.getInstance().copyProperties(activityShow,showDto);
            Activity activity = new Activity();
            activity.setId(showDto.getActivityId());
            activity.setBanner(showDto.getBanner());
            if (showDto.getId()==null) {
                mapper.insertSelective(activityShow);
                activityBiz.updateSelectiveById(activity);
            }else {
                mapper.updateByPrimaryKeySelective(activityShow);
                activityBiz.updateSelectiveById(activity);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.toString());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }
}
