package com.xxfc.platform.order.pojo.calculate;

import cn.hutool.core.collection.CollUtil;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import lombok.Data;
import org.assertj.core.util.Lists;

import java.math.BigDecimal;
import java.util.List;

@Data
public class InProgressVO {
    /**
     * 违约金
     */
    BigDecimal violateAmount = BigDecimal.ZERO;

    /**
     * 赔偿金
     */
    BigDecimal damagesAmount = BigDecimal.ZERO;

    /**
     * 额外费用
     */
    BigDecimal extraAmount = BigDecimal.ZERO;

    /**
     * 实际主要消费金额
     */
    BigDecimal consumeAmount = BigDecimal.ZERO;

    /**
     * 已使用天数
     */
    Integer usedDays = 0;

    /**
     * 已使用的金额
     */
    BigDecimal usedAmount = BigDecimal.ZERO;

    /**
     * 已使用免费天数
     */
    Integer usedfreeDays = 0;

    /**
     * 已使用的免费天数对应的费用
     */
    BigDecimal usedFreeDaysAmount = BigDecimal.ZERO;

    /**
     * 返回订单款金额
     */
    BigDecimal refundOrderAmount = BigDecimal.ZERO;

    /**
     * 返还的优惠券
     */
    List<String> backCoupons = Lists.newArrayList();

    /**
     * 优惠金额
     */
    private BigDecimal couponAmount = BigDecimal.ZERO;

    /**
     * 优惠描述
     */
    private String couponDesc = "";

    /**
     * 返还的免费天数
     */
    Integer backFreeDays = 0;

    String cancelCostDetail = "";

    String advanceDelayCostDetail = "";

    String violateDesc = "";


    /**
     * 使用（消耗）详情列表
     */
    List<VMCalendarPriceCostDTO> useAmountList = CollUtil.newArrayList();

    /**
     * 延期 详情列表
     */
    List<VMCalendarPriceCostDTO> overAmountList = CollUtil.newArrayList();

    /**
     * 违约金 费用详情列表
     */
    List<VMCalendarPriceCostDTO> violateAmountList = CollUtil.newArrayList();
}
