package com.xxfc.platform.order.bo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/23 14:39
 */
@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class CompanyPerformanceBo {

     private Date date;
     private Integer year;
     private String month;
     private String weekOfYear;
     private Integer companyId;
     private String companyName;
     private BigDecimal memberAmount;
     private BigDecimal rentVehilceAmount;
     private BigDecimal travelAmount;
     private BigDecimal noDeductibleAmount;
     private BigDecimal depositAmount;
     private Integer rentDays;
     private BigDecimal extralAmount;
     private Integer  departureNum;
     private Integer   arrivalNum;
     private Date startDate;
     private Date endDate;

     public BigDecimal getMemberAmount() {
          return memberAmount==null?BigDecimal.ZERO:memberAmount;
     }

     public BigDecimal getRentVehilceAmount() {
          return rentVehilceAmount==null?BigDecimal.ZERO:rentVehilceAmount;
     }

     public BigDecimal getTravelAmount() {
          return travelAmount==null?BigDecimal.ZERO:travelAmount;
     }

     public BigDecimal getNoDeductibleAmount() {
          return noDeductibleAmount==null?BigDecimal.ZERO:noDeductibleAmount;
     }

     public BigDecimal getDepositAmount() {
          return depositAmount==null?BigDecimal.ZERO:depositAmount;
     }

     public Integer getRentDays() {
          return rentDays==null?0:rentDays;
     }

     public BigDecimal getExtralAmount() {
          return extralAmount==null?BigDecimal.ZERO:extralAmount;
     }

     public Integer getDepartureNum() {
          return departureNum==null?0:departureNum;
     }

     public Integer getArrivalNum() {
          return arrivalNum==null?0:arrivalNum;
     }
}
