package com.github.wxiaoqi.security.common.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;

import java.util.HashSet;

public class XxBizAssert {
    public static <T> T notNull(T object) throws IllegalArgumentException {
        return notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object... params) throws IllegalArgumentException {
        if (object == null) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE, new HashSet<String>(){{
                add(StrUtil.format(errorMsgTemplate, params));
            }});
        } else {
            return object;
        }
    }

    public static void isNull(Object object, String errorMsgTemplate, Object... params) throws IllegalArgumentException {
        if (object != null) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE, new HashSet<String>(){{
                add(StrUtil.format(errorMsgTemplate, params));
            }});
        }
    }

    public static void isNull(Object object) throws IllegalArgumentException {
        isNull(object, "[Assertion failed] - the object argument must be null");
    }
}
