package com.xxfc.platform.order.config;

import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;


/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitOrderConfig extends RabbitCommonConfig {

    //退款队列 绑定订单完成
    public static final String ORDER_DEPOSIT_REFUND_QUEUE = "order.deposit.refund.queue";


    //第一次分成结算
    public static final String ORDER_DEPOSIT_FINISH_QUEUE = "order.deposit.finish.queue";
    //第二次分成结算
    public static final String ORDER_DEPOSIT_END2_QUEUE = "order.deposit.end2.queue";


    //同步企业信息
    public static final String ORDER_CORPORATION_UPD_QUEUE = "order.corporation:upd.queue";

    //同步门店信息
    public static final String ORDER_COMPANY_UPD_QUEUE = "order.company:upd.queue";

    static {
        myQueue = new ArrayList<BindDTO>(){{
            //第一次押金退还
            add(new BindDTO(ORDER_DEPOSIT_REFUND_QUEUE, ORDER_TOPIC, KEY_ORDER_FINLISH));

            //第一次分成结算
            add(new BindDTO(ORDER_DEPOSIT_FINISH_QUEUE, ORDER_TOPIC, KEY_ORDER_END_1));
            //第二次分成结算
            add(new BindDTO(ORDER_DEPOSIT_END2_QUEUE, ORDER_TOPIC, KEY_ORDER_END_2));

            //企业
            add(new BindDTO(ORDER_CORPORATION_UPD_QUEUE, VEHICLE_TOPIC, KEY_CORPORATION_UPD));
            //门店
            add(new BindDTO(ORDER_COMPANY_UPD_QUEUE, VEHICLE_TOPIC, KEY_COMPANY_UPD));
        }};
    }

}

