package com.xxfc.platform.vehicle.biz;


import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.mapper.BranchCompanyStockInfoMapper;
import com.xxfc.platform.vehicle.mapper.CompanyBaseMapper;
import com.xxfc.platform.vehicle.mapper.SysRegionMapper;
import com.xxfc.platform.vehicle.pojo.dto.CompanyBaseDetailDTO;
import com.xxfc.platform.vehicle.pojo.vo.CompanyBaseVo;
import com.xxfc.platform.vehicle.pojo.vo.CompanyVo;
import com.xxfc.platform.vehicle.util.excel.ExcelImport;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class CompanyBaseBiz extends BaseBiz<CompanyBaseMapper, CompanyBase>  {


     @Autowired
    BranchCompanyStockRightBiz stockRightBiz;

    @Autowired
    BranchCompanyBiz branchCompanyBiz;

     @Autowired
     BranchCompanyStockInfoMapper stockInfoMapper;

     @Autowired
    SysRegionMapper sysRegionMapper;

     @Autowired
    AreaBiz areaBiz;

    @Value("${branchCompanyPic.url}")
    private  String companyUrl;

    //临时数据同步
    public ObjectRestResponse synchro(){
        List<BranchCompanyStockInfo> list= stockInfoMapper.selectAll();
        if (list.size()>0){
            for (BranchCompanyStockInfo companyStockInfo:list){
                int num=0;
                String companyName=companyStockInfo.getCompanyName();
                Integer balance=companyStockInfo.getBalance();
                Integer total=companyStockInfo.getTotal();
                BigDecimal price=companyStockInfo.getPrice();
                CompanyBase companyBase=new CompanyBase();
                companyBase.setAddrCity(companyStockInfo.getAddrCity());
                companyBase.setAddrProvince(companyStockInfo.getAddrProvince());
                companyBase.setName(companyName);
                companyBase.setCover(companyUrl+"/image/admin/upload"+companyStockInfo.getCompanyPic());
                companyBase.setImages(companyUrl+"/image/admin/upload"+companyStockInfo.getCompanyPic());
                insertSelective(companyBase);
                Integer companyBaseId=companyBase.getId();
                if (companyBaseId!=null){
                    BranchCompanyStockRight branchCompanyStockRight=new BranchCompanyStockRight();
                    branchCompanyStockRight.setBalance(balance);
                    branchCompanyStockRight.setPrice(price);
                    branchCompanyStockRight.setTotal(total);
                    branchCompanyStockRight.setCompanyBaseId(companyBaseId);
                    branchCompanyStockRight.setStockState(2);
                    stockRightBiz.insertSelective(branchCompanyStockRight);
                }
                num++;
                log.info("----成功---num=="+num+"---companyBaseId==="+companyBaseId);
            }
        }

        return  ObjectRestResponse.succ();
    }

    //临时数据同步2
    public ObjectRestResponse synchro2(){
        List<BranchCompany> list= branchCompanyBiz.selectListAll();
        if (list.size()>0){
            int num=0;
            for (BranchCompany branchCompany:list){
                Integer companyBaseId=branchCompany.getCompanyBaseId();
                Integer id=branchCompany.getId();
                if (companyBaseId!=null||companyBaseId!=0){
                     CompanyBase companyBase=selectById(companyBaseId);
                     if (companyBase!=null){
                         branchCompany=new BranchCompany();
                         branchCompany.setId(id);
                         branchCompany.setAddrProvince(companyBase.getAddrProvince());
                         branchCompany.setProvinceName(companyBase.getProvinceName());
                         branchCompany.setAddrCity(companyBase.getAddrCity());
                         branchCompany.setCityName(companyBase.getCityName());
                         branchCompany.setAddrTown(companyBase.getAddrTown());
                         branchCompany.setTownName(companyBase.getTownName());
                         branchCompanyBiz.updateSelectiveById(branchCompany);
                         num++;
                         log.info("----成功---num=="+num+"---companyBaseId==="+companyBaseId);
                     }
                }


            }
        }

        return  ObjectRestResponse.succ();
    }

    //临时数据同步3
    public ObjectRestResponse synchro3(){
        List<BranchCompanyStockInfo> list= stockInfoMapper.selectAll();
        if (list.size()>0){
            int num=0;
            for (BranchCompanyStockInfo companyStockInfo:list){
                Integer  id=companyStockInfo.getId();
                Integer balance=companyStockInfo.getBalance();
                Integer total=companyStockInfo.getTotal();
                BigDecimal price=companyStockInfo.getPrice();
                Integer state=companyStockInfo.getState();
                BranchCompanyStockRight branchCompanyStockRight=stockRightBiz.selectById(id);
                if (branchCompanyStockRight!=null){
                    branchCompanyStockRight=new BranchCompanyStockRight();
                    branchCompanyStockRight.setId(id);
                    branchCompanyStockRight.setBalance(balance);
                    branchCompanyStockRight.setStockState(state);
                    branchCompanyStockRight.setTotal(total);
                    branchCompanyStockRight.setPrice(price);
                    stockRightBiz.updateSelectiveById(branchCompanyStockRight);
                    num++;
                }
                log.info("----成功---num=="+num+"---id==="+id);
            }
        }
        return  ObjectRestResponse.succ();
    }
    //设置基础信息
    public  ObjectRestResponse updCompany(CompanyVo companyVo){
        if (companyVo==null|| StringUtils.isBlank(companyVo.getCompanyName())|| StringUtils.isBlank(companyVo.getName())||
                companyVo.getZoneId()==null||companyVo.getZoneId()==0|| companyVo.getAddrProvince()==null||companyVo.getAddrProvince()==0
                || companyVo.getAddrCity()==null||companyVo.getAddrCity()==0){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        Area area=areaBiz.selectById(companyVo.getZoneId());
        Integer provinc=companyVo.getAddrProvince();
        if (area==null||StringUtils.isBlank(area.getProvinceIds())||!area.getProvinceIds().contains(provinc+"")){
            return  ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"片区和省份不一致");
        }
        Integer state=companyVo.getState()==null?2:companyVo.getState();
        BigDecimal latitude=companyVo.getLatitude();
        BigDecimal longitude=companyVo.getLongitude();
        if (state==1&&(StringUtils.isBlank(companyVo.getAddrDetail())||StringUtils.isBlank(companyVo.getImages())||StringUtils.isBlank(companyVo.getDescribes())
                ||latitude==null||longitude==null)){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"上架时参数不能为空");
        }
        CompanyBase companyBase=new CompanyBase();
        BeanUtils.copyProperties(companyVo,companyBase);
        Integer companyBaseId=companyVo.getId();
        if (companyBaseId==null||companyBaseId==0){
            insertSelective(companyBase);
            companyBaseId=companyBase.getId();
        }else {
            updateSelectiveById(companyBase);
        }
        BranchCompany branchCompany=new BranchCompany();
        BeanUtils.copyProperties(companyVo,branchCompany);
        branchCompany.setCompanyBaseId(companyBaseId);
        branchCompany.setName(companyVo.getCompanyName());
        Integer companyId=companyVo.getCompanyId();
        if (companyId==null||companyId==0){
            branchCompany.setId(null);
            branchCompanyBiz.insertSelective(branchCompany);
        }else {
            branchCompany.setId(companyId);
            branchCompanyBiz.updateSelectiveById(branchCompany);
        }
        return  ObjectRestResponse.succ();
    }

    //获取详情
    public  ObjectRestResponse getCompanyDetail(CompanyVo companyVo){
        if (companyVo==null){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        Integer companyBaseId=companyVo.getId();
        Integer companyId=companyVo.getCompanyId();
        Integer stockId=companyVo.getStockId();
        String name="";
        String companyName="";
        String zoneName="";
        if (companyBaseId!=null&&companyBaseId>0){
            CompanyBase companyBase=selectById(companyBaseId);
            BeanUtils.copyProperties(companyBase,companyVo);
            name=companyBase.getName();
            Integer zoneId=companyBase.getZoneId();
            if (zoneId!=null){
                Area area=areaBiz.selectById(zoneId);
                if (area!=null){
                    zoneName=area.getName();
                }
            }

        }
        if (companyId!=null&&companyId>0){
            BranchCompany branchCompany=branchCompanyBiz.selectById(companyId);
            BeanUtils.copyProperties(branchCompany,companyVo);
            companyName=branchCompany.getName();
        }
        if (stockId!=null&&stockId>0){
            BranchCompanyStockRight stockRight=stockRightBiz.selectById(stockId);
            BeanUtils.copyProperties(stockRight,companyVo);
        }
        companyVo.setId(companyBaseId);
        companyVo.setName(name);
        companyVo.setCompanyName(companyName);
        companyVo.setZoneName(zoneName);
        return  ObjectRestResponse.succ(companyVo);
    }

    //设置股权信息
    public  ObjectRestResponse updStockInfo(CompanyVo companyVo){

        if (companyVo==null|| companyVo.getId()==null||companyVo.getId()==0 || companyVo.getBalance()==null||companyVo.getBalance()==0|| companyVo.getTotal()==null||companyVo.getTotal()==0
                ||companyVo.getPrice() ==null|| companyVo.getPrice().compareTo(BigDecimal.ZERO)<0){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        Integer companyBaseId=companyVo.getId();
        Integer stockState=companyVo.getStockState();
        if (stockState!=null&&stockState==2){
            CompanyBase companyBase=selectById(companyBaseId);
            if (companyBase==null||StringUtils.isBlank(companyBase.getDescribes())|| StringUtils.isBlank(companyBase.getContent())||StringUtils.isBlank(companyBase.getImages())){
                return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"基础信息不完善");
            }
        }
        Integer stockId=companyVo.getStockId();
        BranchCompanyStockRight right=new BranchCompanyStockRight();
        BeanUtils.copyProperties(companyVo,right);
        if (stockId==null||stockId==0){
            right.setId(null);
            right.setCompanyBaseId(companyBaseId);
            stockRightBiz.insertSelective(right);
        }else {
            right.setId(stockId);
            stockRightBiz.updateSelectiveById(right);
        }
        return  ObjectRestResponse.succ();
    }

    //设置基础详情
    public  ObjectRestResponse updCompanyDetail(CompanyVo companyVo){
        if (companyVo==null){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        CompanyBase companyBase=new CompanyBase();
        BeanUtils.copyProperties(companyVo,companyBase);
        Integer companyBaseId=companyVo.getId();
        if (companyBaseId==null||companyBaseId==0){
            insertSelective(companyBase);
        }else {
            updateSelectiveById(companyBase);
        }
        return  ObjectRestResponse.succ();
    }

    public  ObjectRestResponse delCompany(Integer id){
        CompanyBase companyBase=new CompanyBase();
        companyBase.setId(id);
        companyBase.setIsDel(1);
        updateSelectiveById(companyBase);
        return  ObjectRestResponse.succ();
    }

    public  ObjectRestResponse getList(CompanyVo companyVo){
        Integer page=1;
        Integer limit=10;
        if (companyVo.getPage()!=null&&companyVo.getPage()>0){
            page=companyVo.getPage();
        }
        if (companyVo.getLimit()!=null&&companyVo.getLimit()>0){
            limit=companyVo.getLimit();
        }
        return  ObjectRestResponse.succ(PageDataVO.pageInfo(page, limit, ()->mapper.getList(companyVo)));
    }

    //分公司和总表同步
    public ObjectRestResponse importExcel(MultipartFile multipartfile, HttpServletRequest request){
        try {
            List<String[]> readExcel = ExcelImport.getExcelData(multipartfile);
            if(readExcel.size()<4){
                return ObjectRestResponse.createFailedResult(1001,"导入不能没数据！！！");
            }
            for (int i = 3; i < readExcel.size(); i++) {
                String[] str = readExcel.get(i);
                String companyId = str[1];
                String companyName = str[2];
                String name = str[3];
                BranchCompany branchCompany=branchCompanyBiz.selectById(companyId);
                String provinceName=sysRegionMapper.getName(branchCompany.getAddrProvince());
                String cityName=sysRegionMapper.getName(branchCompany.getAddrCity());
                String townName=sysRegionMapper.getName(branchCompany.getAddrTown());
                branchCompany.setProvinceName(provinceName);
                branchCompany.setCityName(cityName);
                branchCompany.setTownName(townName);
                CompanyBase companyBase=new CompanyBase();
                companyBase.setName(name);
                companyBase=selectOne(companyBase);
                Integer companyBaseId=0;
                if (companyBase==null){
                    companyBase=new CompanyBase();
                    BeanUtils.copyProperties(branchCompany,companyBase);
                    companyBase.setId(null);
                    companyBase.setName(name);
                    insertSelective(companyBase);
                    companyBaseId=companyBase.getId();
                }else {
                    companyBaseId=companyBase.getId();
                    companyBase.setZoneId(branchCompany.getZoneId());
                    companyBase.setAddrProvince(branchCompany.getAddrProvince());
                    companyBase.setProvinceName(provinceName);
                    companyBase.setAddrCity(branchCompany.getAddrCity());
                    companyBase.setCityName(cityName);
                    companyBase.setAddrTown(branchCompany.getAddrTown());
                    companyBase.setTownName(townName);
                    updateSelectiveById(companyBase);
                }
                branchCompany.setCompanyBaseId(companyBaseId);
                branchCompanyBiz.updateSelectiveById(branchCompany);
            }
        }catch (Exception e){
            e.printStackTrace();
            return ObjectRestResponse.createFailedResult(10001,"网络异常！");
        }
        return ObjectRestResponse.succ();
    }

    

    public CompanyBaseVo findCompanyDetailById(Integer id) {
        CompanyBaseVo companyBaseVo = new CompanyBaseVo();
        CompanyBaseDetailDTO companyBaseDetailDTO = mapper.findCompanyBaseById(id);
        BeanUtils.copyProperties(companyBaseDetailDTO,companyBaseVo);
        return companyBaseVo;
    }

}
