package com.xxfc.platform.im.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.CustomerServiceBiz;
import com.xxfc.platform.im.biz.UserBiz;
import com.xxfc.platform.im.dto.CustomerServiceDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/5 10:32
 */
@RestController
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/admin/customer_service")
public class CustomerServiceAdminController {

     private final CustomerServiceBiz customerServiceBiz;

     private final UserBiz userBiz;


     @PostMapping("/add")
     public ObjectRestResponse<Void> addCustomerService(@RequestBody CustomerServiceDTO customerServiceDTO){
          customerServiceBiz.addCustomerService(customerServiceDTO);
          return ObjectRestResponse.succ();
     }

     @PutMapping("/update_password/{telphone}/{password}")
     public ObjectRestResponse<Void> updateCustomerService(@PathVariable(value = "telphone") String telphone,
                                                           @PathVariable(value = "password") String password){
          userBiz.updatePasswordByPhone(telphone,password);
          return ObjectRestResponse.succ();
     }

     @DeleteMapping("/delete/{id}/{imUserId}")
     public ObjectRestResponse<Void> deleteCustomerService(@PathVariable(value = "id") String id,
                                                           @PathVariable(value = "imUserId") Integer imUserId){
          customerServiceBiz.updateCustomerServiceIsDelToTrue(id,imUserId);
          return ObjectRestResponse.succ();
     }
}
