package com.xxfc.platform.im.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.mongodb.morphia.annotations.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * @author libin
 * @version 1.0
 * @description 客服
 * @data 2019/9/5 9:27
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
@Document(collection = "customer_service")
public class CustomerService {
    private static final long serialVersionUID = 1L;
    @Id
    private String id;
    /**
     * 客服名称
     */
    private String name;
    /**
     * 客服头像
     */
    private String icon;
    /**
     * App id
     */
    @Field("app_user_id")
    private Integer appUserId;
    /**
     * im id
     */
    @Field("im_user_id")
    private Integer imUserId;
    /**
     * 区域id
     */
    @Field("area_id")
    private Integer areaId;
    /**
     * 区域名称
     */
    @Field("area_name")
    private String areaName;
    /**
     * 问候语句
     */
    private String greeting;
    /**
     * 客服类型
     */
    private Integer type;
    /**
     * 客服电话
     */
    private String telphone;
    /**
     * 是事删除 true：删除状态 1：正常
     */
    @Field("is_del")
    private Boolean isDel;

    @Field("create_time")
    private Long createTime;

    @Field("update_time")
    private Long updateTime;

}
