package com.xinxincaravan.caravan.vehicle.rest;

import com.xinxincaravan.caravan.vehicle.biz.VehicleActiveService;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.vo.VehicleArrivalVo;
import com.xinxincaravan.caravan.vehicle.vo.VehicleDepartureVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("active")
public class VehicleActiveController {

    @Autowired
    VehicleActiveService vehicleActiveService;


    /**
     * 发车
     *
     * @return
     */
    @PostMapping("departure")
    public RestResponse departure(@RequestBody VehicleDepartureVo departureVo) {
        if (departureVo == null || departureVo.getVehicleId() == null
                || departureVo.getMileage() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleActiveService.departure(departureVo);
        return RestResponse.suc();
    }

    @PostMapping("arrival")
    public RestResponse arrival(@RequestBody VehicleArrivalVo arrivalVo) {
        if (arrivalVo == null || arrivalVo.getVehicleId() == null
                || arrivalVo.getMileage() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleActiveService.arrival(arrivalVo);
        return RestResponse.suc();
    }


}
