package com.xinxincaravan.caravan.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.xinxincaravan.caravan.vehicle.biz.BranchCompanyBiz;
import com.xinxincaravan.caravan.vehicle.common.BaseController;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.entity.BranchCompany;
import com.xinxincaravan.caravan.vehicle.vo.BranchCompanyVo;
import com.xinxincaravan.caravan.vehicle.vo.PageDataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/branchCompany")
@Slf4j
@IgnoreClientToken
public class BranchCompanyController extends BaseController<BranchCompanyBiz> {


    @RequestMapping(value ="/page",method = RequestMethod.GET)
    public RestResponse<PageDataVo<BranchCompany>> page(@RequestParam Integer page, @RequestParam Integer limit,
                                                          @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                          @RequestParam(required = false) Integer addrTown) {
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity,
                 addrTown));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<BranchCompany>> getAll() {
        return RestResponse.data(baseBiz.getAll());
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.GET)
    public RestResponse<BranchCompany> get(@PathVariable Integer id) {
        return RestResponse.data(baseBiz.getById(id));
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    public RestResponse<Integer> add(@RequestBody BranchCompanyVo branchCompanyVo) {
        return RestResponse.data(baseBiz.add(branchCompanyVo));
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    public RestResponse update(@RequestBody BranchCompany branchCompany) {
        baseBiz.update(branchCompany);
        return RestResponse.sucResponse();
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    public RestResponse del(@PathVariable Integer id) {
        baseBiz.del(id);
        return RestResponse.sucResponse();
    }

}
