package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum VehicleStatus {
    NORMAL(1,"正常运行"),
    REPAIRING(2,"维修"),
    DISCARD(3,"报废"),
    DEPARTURE(4, "出车"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(VehicleStatus constantType : VehicleStatus.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    VehicleStatus(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
