package com.xinxincaravan.caravan.vehicle.constant.ResCode;

public enum ResCode {

    AUTH_FAIL(-1,"权限验证不通过"),


    INVALID_REST_REQ_PARAM(100000,"rest请求参数非法"),

    //车辆信息相关返回码-预定信息
    VEHICLE_BOOKED_INFO_ALREADY_CHANGED(101001,"车辆预定信息已更改，请刷新后继续操作"),

    //车辆信息相关返回码-车辆信息
    VEHICLE_INFO_SAME_NUM_PLATE_EXISTS(102001,"该车牌车辆已经存在"),
    VEHICLE_INFO_BRANCH_NOT_EXIST(102002,"分公司信息非法"),
    VEHICLE_INFO_CODE_EXIST(102003,"车辆编码已存在"),

    //车辆信息相关返回码-预定申请信息
    VEHICLE_BOOKED_RECORD_ALREADY_CHANGED(103001,"车辆预定申请已被审批，请刷新后继续操作"),
    VEHICLE_BOOKED_RECORD_STATUS_CHANGED(103002,"车辆预定申请状态已变更，请刷新后继续操作"),

    VEHICLE_DEPARTURE_VEHICLE_UNEXIST(104001,"车辆不存在"),
    VEHICLE_DEPARTURE_VEHICLE_DISABLE(104002,"车辆不可用"),
    VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE(104003,"车辆未出车"),

    ;
    /**
     * 返回码
     */
    private Integer code;
    /**
     * 描述
     */
    private String desc;

    ResCode(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
