package com.xinxincaravan.caravan.vehicle.biz;

import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.constant.VehicleActiveType;
import com.xinxincaravan.caravan.vehicle.constant.VehicleStatus;
import com.xinxincaravan.caravan.vehicle.entity.Vehicle;
import com.xinxincaravan.caravan.vehicle.entity.VehicleActiveLog;
import com.xinxincaravan.caravan.vehicle.entity.VehicleDepartureLog;
import com.xinxincaravan.caravan.vehicle.mapper.VehicleActiveLogMapper;
import com.xinxincaravan.caravan.vehicle.mapper.VehicleDepartureLogMapper;
import com.xinxincaravan.caravan.vehicle.mapper.VehicleMapper;
import com.xinxincaravan.caravan.vehicle.vo.VehicleArrivalVo;
import com.xinxincaravan.caravan.vehicle.vo.VehicleDepartureVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
public class VehicleActiveService {

    @Autowired
    VehicleMapper vehicleMapper;

    @Autowired
    VehicleDepartureLogMapper vehicleDepartureLogMapper;

    @Autowired
    VehicleActiveLogMapper vehicleActiveLogMapper;

    /**
     * 出车
     *
     * @param departureVo
     */
    @Transactional
    public void departure(VehicleDepartureVo departureVo) {
        Vehicle vehicle = vehicleMapper.selectByPrimaryKey(departureVo.getVehicleId());
        if (vehicle == null) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNEXIST.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNEXIST.getCode());
        }
        if (!vehicle.getStatus().equals(VehicleStatus.NORMAL.getCode())) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_DISABLE.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_DISABLE.getCode());
        }

        // 修改车辆状态，确认是空闲状态
        int result = vehicleMapper.updateStatusByIdAndStatus(departureVo.getVehicleId(), VehicleStatus.DEPARTURE.getCode(),
                VehicleStatus.NORMAL.getCode());

        if (result == 0) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_DISABLE.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_DISABLE.getCode());
        }

        // 出车记录
        VehicleDepartureLog departureLog = new VehicleDepartureLog();
        BeanUtils.copyProperties(departureVo, departureLog);
        departureLog.setDepartureTime(new Date());
        departureLog.setCreateTime(new Date());
        departureLog.setMileageStart(departureVo.getMileage());
        vehicleDepartureLogMapper.insert(departureLog);

        // 车辆活动日志
        VehicleActiveLog activeLog = new VehicleActiveLog();
        activeLog.setVehicleId(departureVo.getVehicleId());
        activeLog.setActiveType(VehicleActiveType.Departure.getCode());
        activeLog.setStartTime(new Date());
        activeLog.setCreateTime(new Date());
        vehicleActiveLogMapper.insert(activeLog);
    }

    @Transactional
    public void arrival(VehicleArrivalVo arrivalVo) {
        Vehicle vehicle = vehicleMapper.selectByPrimaryKey(arrivalVo.getVehicleId());
        if (vehicle == null) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNEXIST.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNEXIST.getCode());
        }
        if (!vehicle.getStatus().equals(VehicleStatus.DEPARTURE.getCode())) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getCode());
        }

        // 修改状态，确认是出车状态
        int result = vehicleMapper.updateStatusByIdAndStatus(arrivalVo.getVehicleId(), VehicleStatus.NORMAL.getCode(),
                VehicleStatus.DEPARTURE.getCode());
        if (result == 0) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getCode());
        }

        // 出车记录
        VehicleDepartureLog departureLog = vehicleDepartureLogMapper.selectLastByVehicleId(arrivalVo.getVehicleId());
        if (departureLog == null) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getCode());
        }
        departureLog.setMileageEnd(arrivalVo.getMileage());
        departureLog.setRecycleMan(arrivalVo.getRecycleMan());
        departureLog.setRecycleManTel(arrivalVo.getRecycleManTel());
        departureLog.setUpdateTime(new Date());
        departureLog.setArrivalTime(new Date());
        vehicleDepartureLogMapper.updateByPrimaryKeySelective(departureLog);

        // 车辆活动日志
        VehicleActiveLog activeLog = vehicleActiveLogMapper.selectLastByVehicleId(arrivalVo.getVehicleId());
        if (activeLog == null) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE.getCode());
        }
        activeLog.setEndTime(new Date());
        activeLog.setUpdateTime(new Date());
        vehicleActiveLogMapper.updateByPrimaryKeySelective(activeLog);
    }
}
