package com.xxfc.platform.vehicle.pojo;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashMap;
import java.util.Map;


@Data
@Builder
@NoArgsConstructor
public class VehicleExcelVo {
    private static Map<Integer, String> map = new HashMap();

    static {
        map.put(1, "正常运行");
        map.put(2, "维修");
        map.put(3, "报废");
    }

    /**
     * 车牌号，空字符串-没有
     */
    private String numberPlate;


    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车型
     */
    private String vehicleType;


    /**
     * 用途名称
     */
    private String useTypeName;


    /**
     * 停靠分支机构（名）
     */

    private String parkBranchCompanyName;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 所属人 名称
     */
    private String belongToName;


    public Integer getStatus() {
        return status;
    }
}
