package com.xxfc.platform.vehicle.pojo;

import lombok.Data;

import java.util.Date;

@Data
public class ResultVehicleVo {
    /**
     * 主键(uuid)
     */
    private String id;

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车牌号，空字符串-没有
     */
    private String numberPlate;


    /**
     * 车型
     */
    private String vehicleType;

    /**
     * 品牌（编码，对应关系见相关常量），0-未填写
     */
    private Integer brand;

    /**
     * 所属分支机构（id）
     */
    private Integer subordinateBranch;
    /**
     * 所属分支机构（名称）
     */
    private String subBranchName;

    /**
     * 停靠分支机构（id）
     */
    private Integer parkBranchCompanyId;
    /**
     * 停靠分支机构（名称）
     */
    private String parkBranchCompanyName;



    /**
     * 目的地分支机构（id）
     */
    private Integer expectDestinationBranchCompanyId;
    /**
     * 目的地分支机构（名称）
     */
    private String expectDestinationBranchCompanyName;


    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    private Integer useType;


    /**
     * 用途名称
     */
    private String useTypeName;

    /**
     * 备注信息
     */
    private String remark;

    private Date createTime;

    private Date updateTime;

    /**
     * 车架号
     */
    private String vin;

    /**
     * 保险公司，见常量表
     */
    private Integer insuranceCompany;


    /**
     * 保险单号
     */
    private String insuranceNo;

    /**
     * 保险开始时间
     */
    private Date insuranceStartDate;

    /**
     * 保险结束时间
     */
    private Date insuranceEndDate;

    /**
     * 年审时间
     */
    private Date annualVerificationDate;

    /**
     * 保养时间
     */
    private Date maintenanceDate;
    /**
     * 当前公里数
     */
    private Integer mileage;

    /**
     * 保养里程数
     */
    private Integer maintenanceMileage;

    /**
     * 车辆所属人-类型
     */
    private Integer belongTo;

    /**
     * 所属人 名称
     */
    private String belongToName;

    /**
     * 行驶证路径
     */
    private String drivingLicensePath;


    /**
     * 发动机号
     */
    private String engineNum;

    /**
     * 生产商
     */
    private String manufacturer;

    /**
     * 收车时间
     */
    private Date receiveTime;

    private Integer modelId;
}