package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityUserJoinBiz;
import com.xxfc.platform.activity.entity.ActivityUserJoin;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("join")
public class ActivityUserJoinController extends BaseController<ActivityUserJoinBiz,ActivityUserJoin> {

    @ApiOperation("新人有礼参加活动")
    @RequestMapping(value = "/user", method = RequestMethod.POST)
    public ObjectRestResponse join(
            @RequestParam(value = "userId",defaultValue ="0" ) Integer userId){
        baseBiz.joinActivity(userId);
        return ObjectRestResponse.succ();
    }

}