package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.uccn.biz.ArticleBiz;
import com.xxfc.platform.uccn.entity.Article;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 文章
 * @author Administrator
 */
@RestController
@RequestMapping("/article")
@Api(tags = {"文章"})
public class ArticleController extends BaseController<ArticleBiz, Article> {

    @GetMapping("/list")
    @ApiOperation(value = "获取文章列表")
     public ObjectRestResponse getArticleList(
             @RequestParam(name = "page",defaultValue = "1") Integer page,
             @RequestParam(name = "limit",defaultValue = "10")Integer limit){
        return ObjectRestResponse.succ(baseBiz.getArticleList(page,limit));
     }
}
