package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.CouponBiz;
import com.xxfc.platform.activity.dto.CouponDTO;
import com.xxfc.platform.activity.dto.CouponFindDTO;
import com.xxfc.platform.activity.vo.CouponPagVo;
import com.xxfc.platform.activity.vo.CouponTitleVo;
import com.xxfc.platform.activity.vo.CouponVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/23 10:39
 */
@RestController
@RequestMapping("/admin/coupon")
public class CouponAdminController {

    @Autowired
    private CouponBiz couponBiz;

    @ApiOperation("优惠券列表")
    @GetMapping("/page")
    public ObjectRestResponse<PageDataVO<CouponPagVo>> listCouponWithPage(CouponFindDTO couponFindDTO) {
        PageDataVO<CouponPagVo> couponPage = couponBiz.listCouponWithPage(couponFindDTO);
        return ObjectRestResponse.succ(couponPage);
    }

    @ApiOperation("查询优惠券详情")
    @GetMapping("/{id}")
    public ObjectRestResponse<CouponVo> findCouponById(@PathVariable(value = "id") Integer id){
       CouponVo couponVo =  couponBiz.findCouponById(id);
       return  ObjectRestResponse.succ(couponVo);
    }

    @ApiOperation("获取优惠劵标题列表")
    @GetMapping("/titles")
    public ObjectRestResponse<List<CouponTitleVo>> getCouponTitleList(){
          List<CouponTitleVo> titles = couponBiz.getCouponTitleList();
      return   ObjectRestResponse.succ(titles);
    }
    @ApiOperation("优惠劵新增 或 编辑")
    @PostMapping
    public ObjectRestResponse<Void> addCoupon(@RequestBody CouponDTO couponDTO, UserDTO userDTO){
        couponBiz.addCoupon(couponDTO,userDTO);
        return ObjectRestResponse.succ();
    }

    @ApiOperation("优惠劵逻辑删除")
    @DeleteMapping("/{id}")
    public ObjectRestResponse<Void> deleteCouponById(@PathVariable(value = "id") Integer id,UserDTO userDTO){
     couponBiz.updateCouponDelStateById(id,userDTO);
     return ObjectRestResponse.succ();
    }

    @ApiOperation("检查优惠劵是否已经在使用阶段")
    @GetMapping("check/{id}")
    public Boolean checkCouponHasUsedById(@PathVariable(value = "id") Integer id){

        return false;
    }
}
