package com.github.wxiaoqi.security.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

/**
 * 验证防止new创建类对象改用单例调用
 * @author GongXiaoBin
 *
 */
public class VerificationUtils {

	private static VerificationUtils pvu = null;


	public static VerificationUtils getPvu() {
		if(pvu==null){
			pvu=new VerificationUtils();
		}
		return pvu;
	}
	
	/**
	 * 参数是否为null或空
	 * @param String parameter
	 * @return boolean
	 */
	public boolean parameterVt(String parameter){
		 boolean bool= null!=parameter||StringUtils.isNotEmpty(parameter)?true:false;
		 return bool;
	}
	
	 /**
	  * 验证邮箱
	  * @param email
	  * @return
	  */
	 public boolean checkEmail(String parameter){
	  boolean flag = false;
	  try{
	    String check = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
	    Pattern regex = Pattern.compile(check);
	    Matcher matcher = regex.matcher(parameter);
	    flag = matcher.matches();
	   }catch(Exception e){
	    flag = false;
	   }
	  return flag;
	 }
	
	 /**
	  * 验证手机号码
	  * @param mobiles
	  * @return
	  */
	 public boolean checkMobileNumber(String parameter){
	  boolean flag = false;
	  try{
	    //Pattern regex = Pattern.compile("^(((13[0-9])|(15([0-3]|[5-9]))|(18[0,5-9]))\\d{8})|(0\\d{2}-\\d{8})|(0\\d{3}-\\d{7})$");
		  Pattern regex = Pattern.compile("1\\d{10}");

	    Matcher matcher = regex.matcher(parameter);
	    flag = matcher.matches();
	   }catch(Exception e){
	    flag = false;
	   }
	  return flag;
	 }
}
