package com.xxfc.platform.activity.feign;

import com.github.wxiaoqi.security.admin.dto.UserInfoDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.dto.ActivityListDTO;
import com.xxfc.platform.activity.dto.ActivityPopularizeRelationDTO;
import com.xxfc.platform.activity.entity.IntegralUserTotal;
import com.xxfc.platform.activity.vo.UserCouponVo;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-activity")
public interface ActivityFeign {

    public static final Integer TYPE_USE = 1;
    public static final Integer TYPE_NO_USE = 0;


    @ApiOperation("用户自动领取新人卷")
    @RequestMapping(value = "/user/auth/led", method = RequestMethod.POST)
    public String led(@RequestParam(value = "userId") Integer userId);

    @ApiOperation("单个优惠卷信息")
    @RequestMapping(value = "/user/info/{no}", method = RequestMethod.GET)
    public UserCouponVo info(@PathVariable(value = "no") String no);

    @ApiOperation("优惠卷使用")
    @RequestMapping(value = "/user/use", method = RequestMethod.POST)
    public BigDecimal use(
            @RequestParam(value = "userId") Integer userId,
            @RequestParam(value = "tickerNos") List<String> tickerNos,
            @RequestParam(value = "orderNo") String orderNo,
            @RequestParam(value = "channel") Integer channel,
            @RequestParam(value = "amount") BigDecimal amount,
            @RequestParam(value = "type") Integer type);

    @ApiOperation("优惠卷取消使用")
    @RequestMapping(value = "/user/cancelUse", method = RequestMethod.POST)
    public ObjectRestResponse cancelUse(@RequestParam(value = "TickerNo", defaultValue = "") String TickerNo);

    @ApiOperation("新人有礼参加活动")
    @RequestMapping(value = "/join/user", method = RequestMethod.POST)
    public ObjectRestResponse join(@RequestParam(value = "userId", defaultValue = "0") Integer userId);

    @ApiModelProperty("获取用户积分")
    @GetMapping(value = "/user/info")
    public UserInfoDTO getUserInfo(@RequestParam("userId") Integer userId);

    @ApiOperation("清除数据")
    @GetMapping("/activity_data/clear")
    ObjectRestResponse<Void> clearDate(@RequestParam(value = "userIds") List<Integer> userIds);

    @ApiOperation("查询活动邀请数据")
    @GetMapping("/activityPopularizeRelation/activity_popularize")
    List<ActivityPopularizeRelationDTO> findActivityPopularizeRelationByActivityIdAndTime(@RequestParam(value = "activityId") Integer activityId,
                                                                                          @RequestParam(value = "startTime", required = false) Long startTime,
                                                                                          @RequestParam(value = "endTime", required = false) Long endTime);

    @ApiOperation("查询活动的时间")
    @GetMapping("/activityList/time/{activityId}")
    ActivityListDTO findActivityStartTimeAndEndTimeById(@PathVariable(value = "activityId") Integer activityId);
}
