package com.xxfc.platform.order.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.google.common.collect.Lists;
import com.xxfc.platform.order.entity.OrderUserLicense;
import com.xxfc.platform.order.mapper.OrderUserLicenseMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class OrderUserLicenseBiz extends BaseBiz<OrderUserLicenseMapper, OrderUserLicense> {

    /**
     * 添加驾驶人信息
     * @param orderUserLicense
     * @return
     */
    public ObjectRestResponse<OrderUserLicense> add(OrderUserLicense orderUserLicense) {
        if(orderUserLicense == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        OrderUserLicense oldValue = mapper.selectByLicenseIdCard(orderUserLicense.getLicenseIdCard());
        if(oldValue == null) {
           insertSelective(orderUserLicense);
            return ObjectRestResponse.succ(mapper.selectByLicenseIdCard(orderUserLicense.getLicenseIdCard()));
        }
        BeanUtil.copyProperties(orderUserLicense, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
        updateSelectiveByIdRe(oldValue);
        return ObjectRestResponse.succ(mapper.selectByLicenseIdCard(oldValue.getLicenseIdCard()));
    }

    /**
     * 根据id获取信息
     * @param ids
     * @return
     */
    public ObjectRestResponse<List<OrderUserLicense>> selectByIds(String ids) {
        if(StringUtils.isBlank(ids)) {
            return ObjectRestResponse.paramIsEmpty();
        }
        List<OrderUserLicense> orderUserLicenses = Lists.newArrayList();
        if(ids.contains(",")) {
            String[] licenseIds = ids.split(",");
            for(String license : licenseIds) {
                OrderUserLicense orderUserLicense = selectById(Integer.parseInt(license));
                if(orderUserLicense != null)
                    orderUserLicenses.add(orderUserLicense);
            }
        } else {
            OrderUserLicense orderUserLicense = selectById(Integer.parseInt(ids));
            if(orderUserLicense != null)
                orderUserLicenses.add(orderUserLicense);
        }
        return ObjectRestResponse.succ(orderUserLicenses);
    }


    public ObjectRestResponse<OrderUserLicense> selectByUserIdCard(String licenseIdCard) {
        if(StringUtils.isBlank(licenseIdCard)) {
            return ObjectRestResponse.paramIsEmpty();
        }
        OrderUserLicense orderUserLicense = mapper.selectByLicenseIdCard(licenseIdCard);
        return ObjectRestResponse.succ(orderUserLicense);
    }

}
